/* -*-C-*-
 ##############################################################################
 #
 # File:        globals.h
 # RCS:         "@(#)$Revision: 1.5 $ $Date: 93/09/27 15:31:16 $"
 # Description: header file for global variable definitions for E1430 
 # Author:      Doug Passey
 # Created:     
 # Language:    C
 # Package:     E1430
 # Status:      "@(#)$State: Exp $"
 #
 # (C) Copyright 1993, Hewlett-Packard Company, all rights reserved.
 #
 ##############################################################################
 #

*/

/* This file contains all the Global Variables that are accessed with
 * in an instrument driver.  Follow the procedure outlined in the
 * "Porting Global Variables" section of the Technical Manual to create
 * portable drivers.
 */

#ifndef HPVXI_GLOBALS			/* Only include this file once */
#define HPVXI_GLOBALS


 /********************************************************************** 
  * NO_EXTERN_FLAG should only be defined in the file where the global *
  * variables will be defined.                                         *
  ********************************************************************** 
  */
#ifdef NO_EXTERN_FLAG
#define GLOBAL
#else
#define GLOBAL extern
#endif 



#define MAX_MAINFRAMES		32	/* maximum number of mainframes */


/********************************************************************
 *                                                                  *
 * Insert Global Variables Here.  Remember to add the GLOBAL macro  *
 *                                                                  *
 *   Example:                                                       *
 *                                                                  *
 *     GLOBAL int my_data;                                          * 
 *                                                                  *
 ********************************************************************
 */
GLOBAL INST e1430_sicl_id;
GLOBAL jmp_buf e1430_env;

GLOBAL SHORTSIZ16 e1430_masters[MAX_MAINFRAMES];
GLOBAL SHORTSIZ16 e1430_groupID;
GLOBAL SHORTSIZ16 e1430_la;
GLOBAL char e1430_error_string[256];
GLOBAL SHORTSIZ16 e1430_printFlag;
GLOBAL SHORTSIZ16 e1430_returnError;
GLOBAL SHORTSIZ16 e1430_debug;

GLOBAL LONGSIZ32 e1430_try;
GLOBAL SHORTSIZ16 *e1430_baseAddr;		/* base of A16 address space */

GLOBAL LONGSIZ32 e1430_timeout;
GLOBAL aModHeadPtr e1430_modGroupID;
GLOBAL SHORTSIZ16 e1430_modGroupIdSize;
GLOBAL aModuleImage DOS_FAR * e1430_modStates;
GLOBAL SHORTSIZ16 e1430_modStatesSize;
GLOBAL SHORTSIZ16 e1430_cur_status;

GLOBAL volatile char e1430_device_clear_flag;

/* declare these so setjmp - longjmp don't screw them up */
GLOBAL LONGSIZ32 e1430_i;
GLOBAL volatile SHORTSIZ16 *e1430_addr;
GLOBAL SHORTSIZ16 e1430_intr_occurred;
GLOBAL SHORTSIZ16 e1430_intr_status;


/* End of Global Variables
 */



#endif /* HPVXI_GLOBALS */

